/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.server;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.packet.IPacket;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CameraInHandAddFrameC2SP(InteractionHand hand, CompoundTag frame) implements IPacket
{
    public static final ResourceLocation ID = Exposure.resource("camera_in_hand_add_frame");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.hand);
        buffer.m_130079_(this.frame);
        return buffer;
    }

    public static CameraInHandAddFrameC2SP fromBuffer(FriendlyByteBuf buffer) {
        InteractionHand hand = (InteractionHand)buffer.m_130066_(InteractionHand.class);
        @Nullable CompoundTag frame = buffer.m_130261_();
        if (frame == null) {
            frame = new CompoundTag();
        }
        return new CameraInHandAddFrameC2SP(hand, frame);
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Cannot handle packet: Player was null");
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack itemInHand = player.m_21120_(this.hand);
        Item item = itemInHand.m_41720_();
        if (!(item instanceof CameraItem)) {
            throw new IllegalStateException("Item in hand in not a Camera.");
        }
        CameraItem cameraItem = (CameraItem)item;
        this.addStructuresInfo(serverPlayer);
        cameraItem.addFrameToFilm(itemInHand, this.frame);
        Exposure.Advancements.FILM_FRAME_EXPOSED.trigger(serverPlayer, new ItemAndStack<CameraItem>(itemInHand), this.frame);
        return true;
    }

    private void addStructuresInfo(@NotNull ServerPlayer player) {
        Map allStructuresAt = player.m_9236_().m_215010_().m_220522_(player.m_20183_());
        ArrayList<Structure> inside = new ArrayList<Structure>();
        for (Structure structure : allStructuresAt.keySet()) {
            StructureStart structureAt = player.m_9236_().m_215010_().m_220494_(player.m_20183_(), structure);
            if (!structureAt.m_73603_()) continue;
            inside.add(structure);
        }
        Registry structures = player.m_9236_().m_5962_().m_175515_(BuiltinRegistries.f_235988_.m_123023_());
        ListTag structuresTag = new ListTag();
        for (Structure structure : inside) {
            ResourceLocation key = structures.m_7981_((Object)structure);
            if (key == null) continue;
            structuresTag.add((Object)StringTag.m_129297_((String)key.toString()));
        }
        if (structuresTag.size() > 0) {
            this.frame.m_128365_("Structures", (Tag)structuresTag);
        }
    }
}

